define(['angular', 'app', 'moment'], function (angular, app, moment) {
	"use strict";

	app.filter('navItemDate', function(dateFilter) {
		return function(dt) {

			var date = moment(dt).hour(0).minute(0).second(0).millisecond(0), // reset times to midnight so diff by day works
				now = moment().hour(0).minute(0).second(0).millisecond(0);

			if (now.isSame(date, 'd')) {
				return 'Today'
			} else if (now.diff(date, 'days') === 1) {
				return 'Yesterday'
			} else {
				return date.format('MM/DD/YY');
			}
		};
	});
});